import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.beans.*;
import java.util.*;

import Sirius.columnchart.*;

public class ColumnchartApp {

    // Bean Object
    private Columnchart columnchart;

    // Data Objects
    private Vector imagedata;   // Image Objects
    private Vector textdata;    // Text Objects
    private Vector titledata;   // Title Objects (Main Title, X Title, Y Title)
    private Vector xlabelsdata; // X labels Objects
    private Vector ylabelsdata; // Y labels Objects
    private Vector columndata;  // Point data Objects
    private Vector seriesdata;  // Series data Objects
    private Vector chartdata;   // Chart Properties Object
    private Vector legenddata;  // Legend Properties
    private Vector minmaxdata;  // Min Max Data lines

	public static void main(String args[]) {
		new ColumnchartApp();
	}

	public ColumnchartApp() {
		Frame f = new Frame();
		f.setSize(758,435);
		f.addWindowListener(new ApplicationWindowAdapter());
		try {
			columnchart = (Columnchart)Beans.instantiate(null,"Sirius/columnchart/Columnchart");

            set_imagedata();
            set_chartdata();
            set_legenddata();
            set_titledata();
            set_textdata();
            set_xlabelsdata();
            set_ylabelsdata();
            set_seriescolumndata();
            set_minmaxdata();

			f.setLayout(null);
			columnchart.setSize(750,420);
			Dimension d = columnchart.getSize();
			columnchart.setBounds(5,22,d.width, d.height);
			f.add(columnchart);
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
		f.setVisible(true);
	}

//-----------------------------------------------------------------------------
// Create the chartdata object
//
    private void set_chartdata() {
      chartdata = new Vector();
      chartdata.addElement(new Chartdata(true,                   // threeD
                                         true,                   // grid
                                         true,                   // axis
                                         true,                   // ylabels
                                         true,                   // outline
                                         true,                   // legend
                                         750,                    // width
                                         420,                    // height
                                         12,                     // number of points,
                                         7,                      // number of nrows,
                                         30,                     // vertical spacing,
                                         3,                      // number of series,
                                         50,                     // horizontal spacing,
                                         75,                     // gridxpos,
                                         350,                    // gridypos,
                                         15,                     // depth3D,
                                         2,                      // ndecplaces,
                                         10,                     // Column width
                                         100,                    // chartScale,
                                         2000,                   // chartStartY,
                                         new Color(175,175,175), // gridColor,
										 new Color(255,255,255), // axisColor,
										 new Color(100,100,100), // floorColor,
										 new Color(255,255,255), // labelColor,
                                         new Color(0,0,0),       // backgroundColor
                                         new Color(0,0,0)        // Outline Color
                                        ));
      columnchart.setChartdata(chartdata);
	}
//-----------------------------------------------------------------------------
// Create the legenddata object
//
    private void set_legenddata() {
       legenddata = new Vector();
       legenddata.addElement(new Legenddata("Indices",                         // Legend title
                                            new Color(200,200,200),            // Legend text color
                                            new Font("Courier",Font.PLAIN,12), // Legend text font
                                            new Point(500,60)                  // Legend top-left position (x,y)
                                           ));
       columnchart.setLegenddata(legenddata);
	}
//-----------------------------------------------------------------------------
// Create the  titledata object
//
    private void set_titledata() {
       titledata = new Vector();
       titledata = new Vector();
       titledata.addElement(new Titledata("Market Indices",new Color(255,255,100),new Font("TimesRoman",Font.BOLD + Font.ITALIC,24),new Point(100,30)));
       titledata.addElement(new Titledata("Year 2000",new Color(0,255,255),new Font("TimesRoman",Font.ITALIC,18),new Point(200,405)));
       titledata.addElement(new Titledata("Index Value",new Color(0,255,255),new Font("TimesRoman",Font.ITALIC,18),new Point(5,375)));
       columnchart.setTitledata(titledata);
	}
//-----------------------------------------------------------------------------
// Create the Images data object
//
    private void set_imagedata() {
       imagedata = new Vector();
	   columnchart.setImagedata(imagedata);
	}

//-----------------------------------------------------------------------------
    private java.awt.Image loadImage(String name) {
	   try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(name);
            if (image==null) {System.err.println(("Unable to load image : "+name));}
  		    return image;

	   }
	   catch (Exception ex) {
           System.err.println("Error loading image.");
    	   System.err.println(ex);
	       return null;
	   }
    }
//-----------------------------------------------------------------------------
// Create the text object
//
    private void set_textdata() {
       textdata = new Vector();
       textdata.addElement(new Textdata("Notes:",                          // Text line 1
                                        new Color(255,255,255),            // text color
                                        new Font("Courier",Font.BOLD,12),  // text font
                                        new Point(45,60)                   // text position (x,y)
                                        ));
       textdata.addElement(new Textdata("Fictitious market indices",       // Text line 2
                                        new Color(255,255,255),            // text color
                                        new Font("Courier",Font.PLAIN,12), // text font
                                        new Point(50,72)                   // text position (x,y)
                                        ));
       textdata.addElement(new Textdata("for the year 2000.",              // Text line 3
                                        new Color(255,255,255),            // text color
                                        new Font("Courier",Font.PLAIN,12), // text font
                                        new Point(50,84)                   // text position (x,y)
                                        ));
       columnchart.setTextdata(textdata);
	}
//-----------------------------------------------------------------------------
// Create the xlabels object
//
    private void set_xlabelsdata() {
       xlabelsdata = new Vector();
       xlabelsdata.addElement(new Xlabelsdata("January",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 365, 0));
       xlabelsdata.addElement(new Xlabelsdata("February",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 375, 0));
       xlabelsdata.addElement(new Xlabelsdata("March",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 365, 0));
       xlabelsdata.addElement(new Xlabelsdata("April",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 375, 0));
       xlabelsdata.addElement(new Xlabelsdata("May",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 365, 0));
       xlabelsdata.addElement(new Xlabelsdata("June",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 375, 0));
       xlabelsdata.addElement(new Xlabelsdata("July",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 365, 0));
       xlabelsdata.addElement(new Xlabelsdata("August",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 375, 0));
       xlabelsdata.addElement(new Xlabelsdata("September",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 365, 0));
       xlabelsdata.addElement(new Xlabelsdata("October",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 375, 0));
       xlabelsdata.addElement(new Xlabelsdata("November",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 365, 0));
       xlabelsdata.addElement(new Xlabelsdata("December",new Color(0,255,255),new Font("Courier",Font.PLAIN,10), 375, 0));
       columnchart.setXlabelsdata(xlabelsdata);
	}

//-----------------------------------------------------------------------------
// Create the ylabels data object
//
    private void set_ylabelsdata() {
       ylabelsdata = new Vector();
       ylabelsdata.addElement(new Ylabelsdata(new Color(100,255,255),new Font("Courier",Font.PLAIN,10)));
       columnchart.setYlabelsdata(ylabelsdata);
	}
//-----------------------------------------------------------------------------
// Create the  series and column objects
//
    private void set_seriescolumndata() {
         seriesdata = new Vector();
         // Series 1
         columndata = new Vector();
         columndata.addElement(new Columndata(2420.45, false));
         columndata.addElement(new Columndata(2630.56, false));
         columndata.addElement(new Columndata(2700.90, true));
         columndata.addElement(new Columndata(2500.40, false));
         columndata.addElement(new Columndata(2450.20, false));
         columndata.addElement(new Columndata(2380.45, false));
         columndata.addElement(new Columndata(2230.56, true));
         columndata.addElement(new Columndata(2400.90, false));
         columndata.addElement(new Columndata(2450.45, false));
         columndata.addElement(new Columndata(2350.45, false));
         columndata.addElement(new Columndata(2320.56, false));
         columndata.addElement(new Columndata(2530.20, true));
         seriesdata.addElement(new Seriesdata("Tech Sector", new Color(255,50,50), columndata));

         // Series 2
         columndata = new Vector();
	     columndata.addElement(new Columndata(2220.45, false));
	     columndata.addElement(new Columndata(2180.56, false));
	     columndata.addElement(new Columndata(2160.56, true));
	     columndata.addElement(new Columndata(2165.40, false));
	     columndata.addElement(new Columndata(2230.20, false));
	     columndata.addElement(new Columndata(2250.87, false));
	     columndata.addElement(new Columndata(2267.15, false));
	     columndata.addElement(new Columndata(2305.91, false));
	     columndata.addElement(new Columndata(2330.12, true));
	     columndata.addElement(new Columndata(2300.63, false));
	     columndata.addElement(new Columndata(2290.54, false));
	     columndata.addElement(new Columndata(2250.74, false));
         seriesdata.addElement(new Seriesdata("Banks", new Color(255,0,255), columndata));

         // Series 3
         columndata = new Vector();
	     columndata.addElement(new Columndata(2000.44, false));
	     columndata.addElement(new Columndata(2050.51, false));
	     columndata.addElement(new Columndata(2075.41, false));
	     columndata.addElement(new Columndata(2040.32, false));
	     columndata.addElement(new Columndata(2010.41, false));
	     columndata.addElement(new Columndata(2085.11, true));
	     columndata.addElement(new Columndata(2007.44, false));
	     columndata.addElement(new Columndata(2020.22, false));
	     columndata.addElement(new Columndata(2020.21, false));
	     columndata.addElement(new Columndata(2040.65, false));
	     columndata.addElement(new Columndata(2069.33, false));
	     columndata.addElement(new Columndata(2210.51, true));
         seriesdata.addElement(new Seriesdata("Oil", new Color(50,255,50), columndata));

         columnchart.setSeriesdata(seriesdata);
	}
//----------------------------------------------------------------------------
// Create the Min Max Line data object
//
    private void set_minmaxdata() {
		minmaxdata = new Vector();
		columnchart.setMinmaxdata(minmaxdata);
	}
//-----------------------------------------------------------------------------
    class ApplicationWindowAdapter extends WindowAdapter {
		public void windowClosing(WindowEvent we) {
			System.exit(0);
		}
	}
//-----------------------------------------------------------------------------
} // End application class
